

####################
# Property Config
####################

propertyStructure = [
["edu.cmu.cs.stage3.alice.core.Text3D",
	["text properties",
		"text",
		"font",
		"extrusion",
		"curvature",
	],
	["appearance properties",
		"color",
		"opacity",
		"diffuseColorMap",
		"fillingStyle",
		"vehicle",
		"isShowing",
		"localTransformation",
	],
	["seldom used properties",
		"isPivotShowing",
		"isBoundingBoxShowing",
		"isBoundingSphereShowing",
		"isFirstClass",
		"emissiveColor",
		"specularHighlightColor",
		"specularHighlightExponent",
		"shadingStyle",
		"eventsStopAscending",
		"opacityMap",
		
	],
],
["edu.cmu.cs.stage3.alice.core.camera.SymmetricPerspectiveCamera",
	["general properties",
		"vehicle",
		"localTransformation",
	],
	["seldom used properties",
		"verticalViewingAngle",
		"horizontalViewingAngle",
		"nearClippingPlaneDistance",
		"farClippingPlaneDistance",
		"renderTarget",
	],
],
["edu.cmu.cs.stage3.alice.core.camera.PerspectiveCamera",
	["general properties",
		"vehicle",
		"localTransformation",
	],
	["seldom used properties",
		"nearClippingPlaneDistance",
		"farClippingPlaneDistance",
		"minimumX",
		"minimumY",
		"maximumX",
		"maximumY",
		"renderTarget",
	],
],
["edu.cmu.cs.stage3.alice.core.camera.OrthographicCamera",
	["general properties",
		"vehicle",
		"localTransformation",
	],
	["seldom used properties",
		"nearClippingPlaneDistance",
		"farClippingPlaneDistance",
		"minimumX",
		"minimumY",
		"maximumX",
		"maximumY",
		"renderTarget",
	],
],
["edu.cmu.cs.stage3.alice.core.light.AmbientLight",
	["general properties",
		"color",
		"brightness",
		"range",
	],
	["seldom used properties",
		"vehicle",
		"localTransformation",
	],
],
["edu.cmu.cs.stage3.alice.core.light.DirectionalLight",
	["general properties",
		"color",
		"brightness",
		"range",
	],
	["seldom used properties",
		"isPivotShowing",
		"vehicle",
		"localTransformation",
	],
],
["edu.cmu.cs.stage3.alice.core.light.SpotLight",
	["general properties",
		"color",
		"brightness",
		"range",
		"innerBeamAngle",
		"outerBeamAngle",
		"vehicle",
		"localTransformation",
	],
	["seldom used properties",
		"isPivotShowing",
		"constantAttenuation",
		"linearAttenuation",
		"quadraticAttenuation",
	],
],
["edu.cmu.cs.stage3.alice.core.light.PointLight",
	["general properties",
		"color",
		"brightness",
		"range",
		"vehicle",
		"localTransformation",
	],
	["seldom used properties",
		"isPivotShowing",
		"constantAttenuation",
		"linearAttenuation",
		"quadraticAttenuation",
	],
],
["edu.cmu.cs.stage3.alice.core.World",
	["general properties",
		"atmosphereColor",
		"ambientLightColor",
		"ambientLightBrightness",
		"fogStyle",
		"fogDensity",
		"fogNearDistance",
		"fogFarDistance",
	],
	["seldom used properties",
		"speedMultiplier",
	],
],
["edu.cmu.cs.stage3.alice.core.Dummy",
	["general properties",
		"vehicle",
		"localTransformation",
	],
],
["edu.cmu.cs.stage3.alice.core.Model",
	["appearance properties",
		"color",
		"opacity",
		"vehicle",
		"diffuseColorMap",
		"fillingStyle",
		"localTransformation",
		"isShowing",
	],
	["seldom used properties",
		"isPivotShowing",
		"isFirstClass",
		"isBoundingBoxShowing",
		"isBoundingSphereShowing",
		"emissiveColor",
		"specularHighlightColor",
		"specularHighlightExponent",
		"shadingStyle",
		"eventsStopAscending",
		"opacityMap",
	],
],
]

classesToOmitNoneFor = [
	java.lang.Boolean,
	java.lang.Number,
	java.lang.String,
	edu.cmu.cs.stage3.util.Enumerable,
	edu.cmu.cs.stage3.alice.scenegraph.Color,
	javax.vecmath.Vector3d,
	javax.vecmath.Matrix4d,
	edu.cmu.cs.stage3.math.Quaternion,
	edu.cmu.cs.stage3.alice.core.ReferenceFrame,
]

propertiesToOmitNoneFor = [
]

propertiesToIncludeNoneFor = [
	["diffuseColorMap", "edu.cmu.cs.stage3.alice.core.Model"],
	["keyCode", "edu.cmu.cs.stage3.alice.core.behavior.KeyClickBehavior"],
	["keyCode", "edu.cmu.cs.stage3.alice.core.behavior.KeyIsPressedBehavior"],
	["onWhat", "edu.cmu.cs.stage3.alice.core.behavior.MouseButtonClickBehavior"],
	["onWhat", "edu.cmu.cs.stage3.alice.core.behavior.MouseButtonIsPressedBehavior"],
	["keyMap", "edu.cmu.cs.stage3.alice.core.behavior.KeyboardNavigationBehavior"],
	["duration", "edu.cmu.cs.stage3.alice.core.response.SoundResponse"],
	["fromMarker", "edu.cmu.cs.stage3.alice.core.response.SoundResponse"],
	["toMarker", "edu.cmu.cs.stage3.alice.core.response.SoundResponse"],
]

propertyNamesToOmit = [
	("subject", "edu.cmu.cs.stage3.alice.core.question.visualization.array.ItemAtIndex"),
	("index", "edu.cmu.cs.stage3.alice.core.question.visualization.array.ItemAtIndex"),
	("subject", "edu.cmu.cs.stage3.alice.core.question.visualization.array.Size"),

	("subject", "edu.cmu.cs.stage3.alice.core.response.visualization.array.ArrayVisualizationAnimation"),
	("item", "edu.cmu.cs.stage3.alice.core.response.visualization.array.ArrayVisualizationWithItemAnimation"),
	("index", "edu.cmu.cs.stage3.alice.core.response.visualization.array.SetItemAtIndex"),

	("subject", "edu.cmu.cs.stage3.alice.core.question.visualization.list.Contains"),
	("item", "edu.cmu.cs.stage3.alice.core.question.visualization.list.Contains"),
	("subject", "edu.cmu.cs.stage3.alice.core.question.visualization.list.FirstIndexOfItem"),
	("item", "edu.cmu.cs.stage3.alice.core.question.visualization.list.FirstIndexOfItem"),
	("subject", "edu.cmu.cs.stage3.alice.core.question.visualization.list.LastIndexOfItem"),
	("item", "edu.cmu.cs.stage3.alice.core.question.visualization.list.LastIndexOfItem"),
	("subject", "edu.cmu.cs.stage3.alice.core.question.visualization.list.IsEmpty"),
	("subject", "edu.cmu.cs.stage3.alice.core.question.visualization.list.Size"),
	("subject", "edu.cmu.cs.stage3.alice.core.question.visualization.list.ItemAtBeginning"),
	("subject", "edu.cmu.cs.stage3.alice.core.question.visualization.list.ItemAtEnd"),
	("subject", "edu.cmu.cs.stage3.alice.core.question.visualization.list.ItemAtIndex"),
	("index", "edu.cmu.cs.stage3.alice.core.question.visualization.list.ItemAtIndex"),

	("subject", "edu.cmu.cs.stage3.alice.core.response.visualization.list.ListVisualizationAnimation"),
	("item", "edu.cmu.cs.stage3.alice.core.response.visualization.list.ListVisualizationWithItemAnimation"),
	("index", "edu.cmu.cs.stage3.alice.core.response.visualization.list.InsertItemAtIndex"),
	("index", "edu.cmu.cs.stage3.alice.core.response.visualization.list.RemoveItemFromIndex"),

	("subject", "edu.cmu.cs.stage3.alice.core.question.visualization.model.Item"),
	("subject", "edu.cmu.cs.stage3.alice.core.response.visualization.model.SetItem"),
	("item", "edu.cmu.cs.stage3.alice.core.response.visualization.model.SetItem"),

	("subject", "edu.cmu.cs.stage3.alice.core.response.TransformAnimation"),
	("subject", "edu.cmu.cs.stage3.alice.core.response.DirectionAmountTransformAnimation"),
	("subject", "edu.cmu.cs.stage3.alice.core.response.DirectionSpeedTransformResponse"),
	("direction", "edu.cmu.cs.stage3.alice.core.response.DirectionAmountTransformAnimation"),
	("direction", "edu.cmu.cs.stage3.alice.core.response.DirectionSpeedTransformResponse"),
	("amount", "edu.cmu.cs.stage3.alice.core.response.DirectionAmountTransformAnimation"),
	("asSeenBy", "edu.cmu.cs.stage3.alice.core.response.PositionAnimation"),
	("amount", "edu.cmu.cs.stage3.alice.core.response.PlaceAnimation"),
	("spatialRelation", "edu.cmu.cs.stage3.alice.core.response.PlaceAnimation"),
	("asSeenBy", "edu.cmu.cs.stage3.alice.core.response.PlaceAnimation"),
	("asSeenBy", "edu.cmu.cs.stage3.alice.core.response.PointOfViewAnimation"),
	("asSeenBy", "edu.cmu.cs.stage3.alice.core.response.QuaternionAnimation"),
	("subject", "edu.cmu.cs.stage3.alice.core.response.ResizeAnimation"),
	("dimension", "edu.cmu.cs.stage3.alice.core.response.ResizeAnimation"),
	("amount", "edu.cmu.cs.stage3.alice.core.response.ResizeAnimation"),
	("subject", "edu.cmu.cs.stage3.alice.core.response.PointAtAnimation"),
	("subject", "edu.cmu.cs.stage3.alice.core.response.PointAtConstraint"),
	("target", "edu.cmu.cs.stage3.alice.core.response.PointAtAnimation"),
	("target", "edu.cmu.cs.stage3.alice.core.response.PointAtConstraint"),
	("subject", "edu.cmu.cs.stage3.alice.core.response.TurnToFaceAnimation"),
	("subject", "edu.cmu.cs.stage3.alice.core.response.TurnToFaceConstraint"),
	("target", "edu.cmu.cs.stage3.alice.core.response.TurnToFaceAnimation"),
	("target", "edu.cmu.cs.stage3.alice.core.response.TurnToFaceConstraint"),
	("subject", "edu.cmu.cs.stage3.alice.core.response.TurnAwayFromAnimation"),
	("subject", "edu.cmu.cs.stage3.alice.core.response.TurnAwayFromConstraint"),
	("target", "edu.cmu.cs.stage3.alice.core.response.TurnAwayFromAnimation"),
	("target", "edu.cmu.cs.stage3.alice.core.response.TurnAwayFromConstraint"),
	("subject", "edu.cmu.cs.stage3.alice.core.response.GetAGoodLookAtAnimation"),
	("target", "edu.cmu.cs.stage3.alice.core.response.GetAGoodLookAtAnimation"),
	("element", "edu.cmu.cs.stage3.alice.core.response.PropertyAnimation"),
	("propertyName", "edu.cmu.cs.stage3.alice.core.response.PropertyAnimation"),
	("value", "edu.cmu.cs.stage3.alice.core.response.PropertyAnimation"),
	("subject", "edu.cmu.cs.stage3.alice.core.response.SoundResponse"),
	("sound", "edu.cmu.cs.stage3.alice.core.response.SoundResponse"),
	("duration", "edu.cmu.cs.stage3.alice.core.response.Wait"),
	("userDefinedResponse", "edu.cmu.cs.stage3.alice.core.response.CallToUserDefinedResponse"),
	("requiredActualParameters", "edu.cmu.cs.stage3.alice.core.response.CallToUserDefinedResponse"),
	("keywordActualParameters", "edu.cmu.cs.stage3.alice.core.response.CallToUserDefinedResponse"),
	("condition", "edu.cmu.cs.stage3.alice.core.response.IfElseInOrder"),
	("condition", "edu.cmu.cs.stage3.alice.core.response.WhileLoopInOrder"),
	("script", "edu.cmu.cs.stage3.alice.core.response.ScriptResponse"),
	("script", "edu.cmu.cs.stage3.alice.core.response.ScriptDefinedResponse"),
	("keyCode", "edu.cmu.cs.stage3.alice.core.behavior.KeyClickBehavior"),
	("keyCode", "edu.cmu.cs.stage3.alice.core.behavior.KeyIsPressedBehavior"),
	("onWhat", "edu.cmu.cs.stage3.alice.core.behavior.MouseButtonClickBehavior"),
	("onWhat", "edu.cmu.cs.stage3.alice.core.behavior.MouseButtonIsPressedBehavior"),
	("objects", "edu.cmu.cs.stage3.alice.core.behavior.DefaultMouseInteractionBehavior"),
	("condition", "edu.cmu.cs.stage3.alice.core.behavior.ConditionalBehavior"),
	("variable", "edu.cmu.cs.stage3.alice.core.behavior.VariableChangeBehavior"),
	("marker", "edu.cmu.cs.stage3.alice.core.behavior.SoundMarkerPassedBehavior"),
	("level", "edu.cmu.cs.stage3.alice.core.behavior.SoundLevelBehavior"),
	("subject", "edu.cmu.cs.stage3.alice.core.behavior.KeyboardNavigationBehavior"),
	("start", "edu.cmu.cs.stage3.alice.core.response.LoopNInOrder"),
	("increment", "edu.cmu.cs.stage3.alice.core.response.LoopNInOrder"),
	("end", "edu.cmu.cs.stage3.alice.core.response.LoopNInOrder"),
	("start", "edu.cmu.cs.stage3.alice.core.question.userdefined.LoopN"),
	("increment", "edu.cmu.cs.stage3.alice.core.question.userdefined.LoopN"),
	("end", "edu.cmu.cs.stage3.alice.core.question.userdefined.LoopN"),
	("list", "edu.cmu.cs.stage3.alice.core.response.ForEach"),
	("subject", "edu.cmu.cs.stage3.alice.core.question.SubjectQuestion"),
	("subject", "edu.cmu.cs.stage3.alice.core.question.SubjectObjectQuestion"),
	("object", "edu.cmu.cs.stage3.alice.core.question.SubjectObjectQuestion"),
	("subject", "edu.cmu.cs.stage3.alice.core.response.PoseAnimation"),
	("pose", "edu.cmu.cs.stage3.alice.core.response.PoseAnimation"),
	("subject", "edu.cmu.cs.stage3.alice.core.response.SayAnimation"),
	("what", "edu.cmu.cs.stage3.alice.core.response.SayAnimation"),
	("subject", "edu.cmu.cs.stage3.alice.core.response.ThinkAnimation"),
	("what", "edu.cmu.cs.stage3.alice.core.response.ThinkAnimation"),
	("probabilityOfTrue", "edu.cmu.cs.stage3.alice.core.question.RandomBoolean"),
	("text", "edu.cmu.cs.stage3.alice.core.response.Comment"),
	("text", "edu.cmu.cs.stage3.alice.core.response.Print"),
	("object", "edu.cmu.cs.stage3.alice.core.response.Print"),
	("variable", "edu.cmu.cs.stage3.alice.core.response.Increment"),
	("variable", "edu.cmu.cs.stage3.alice.core.response.Decrement"),
	("vector3", "edu.cmu.cs.stage3.alice.core.response.vector3.Vector3Response"),
	("value", "edu.cmu.cs.stage3.alice.core.response.vector3.Vector3Response"),
	("vector3", "edu.cmu.cs.stage3.alice.core.question.vector3.Vector3NumberQuestion"),

	("condition", "edu.cmu.cs.stage3.alice.core.question.userdefined.IfElse"),
	("condition", "edu.cmu.cs.stage3.alice.core.question.userdefined.While"),
	("end", "edu.cmu.cs.stage3.alice.core.question.userdefined.LoopN"),
	("list", "edu.cmu.cs.stage3.alice.core.question.userdefined.ForEach"),
	("text", "edu.cmu.cs.stage3.alice.core.question.userdefined.Comment"),
	("text", "edu.cmu.cs.stage3.alice.core.question.userdefined.Print"),
	("object", "edu.cmu.cs.stage3.alice.core.question.userdefined.Print"),
	("element", "edu.cmu.cs.stage3.alice.core.question.userdefined.PropertyAssignment"),
	("propertyName", "edu.cmu.cs.stage3.alice.core.question.userdefined.PropertyAssignment"),
	("value", "edu.cmu.cs.stage3.alice.core.question.userdefined.PropertyAssignment"),

	("list", "edu.cmu.cs.stage3.alice.core.response.list.InsertItemAtBeginning"),
	("item", "edu.cmu.cs.stage3.alice.core.response.list.InsertItemAtBeginning"),
	("list", "edu.cmu.cs.stage3.alice.core.response.list.InsertItemAtEnd"),
	("item", "edu.cmu.cs.stage3.alice.core.response.list.InsertItemAtEnd"),
	("list", "edu.cmu.cs.stage3.alice.core.response.list.InsertItemAtIndex"),
	("item", "edu.cmu.cs.stage3.alice.core.response.list.InsertItemAtIndex"),
	("index", "edu.cmu.cs.stage3.alice.core.response.list.InsertItemAtIndex"),
	("list", "edu.cmu.cs.stage3.alice.core.response.list.RemoveItemFromBeginning"),
	("item", "edu.cmu.cs.stage3.alice.core.response.list.RemoveItemFromBeginning"),
	("list", "edu.cmu.cs.stage3.alice.core.response.list.RemoveItemFromEnd"),
	("item", "edu.cmu.cs.stage3.alice.core.response.list.RemoveItemFromEnd"),
	("list", "edu.cmu.cs.stage3.alice.core.response.list.RemoveItemFromIndex"),
	("item", "edu.cmu.cs.stage3.alice.core.response.list.RemoveItemFromIndex"),
	("index", "edu.cmu.cs.stage3.alice.core.response.list.RemoveItemFromIndex"),
	("list", "edu.cmu.cs.stage3.alice.core.response.list.Clear"),

	("array", "edu.cmu.cs.stage3.alice.core.response.array.SetItemAtIndex"),
	("item", "edu.cmu.cs.stage3.alice.core.response.array.SetItemAtIndex"),
	("index", "edu.cmu.cs.stage3.alice.core.response.array.SetItemAtIndex"),

	("a", "edu.cmu.cs.stage3.alice.core.question.BinaryBooleanResultingInBooleanQuestion"),
	("b", "edu.cmu.cs.stage3.alice.core.question.BinaryBooleanResultingInBooleanQuestion"),
	("a", "edu.cmu.cs.stage3.alice.core.question.BinaryNumberResultingInBooleanQuestion"),
	("b", "edu.cmu.cs.stage3.alice.core.question.BinaryNumberResultingInBooleanQuestion"),
	("a", "edu.cmu.cs.stage3.alice.core.question.BinaryNumberResultingInNumberQuestion"),
	("b", "edu.cmu.cs.stage3.alice.core.question.BinaryNumberResultingInNumberQuestion"),
	("a", "edu.cmu.cs.stage3.alice.core.question.BinaryObjectResultingInBooleanQuestion"),
	("b", "edu.cmu.cs.stage3.alice.core.question.BinaryObjectResultingInBooleanQuestion"),
	("a", "edu.cmu.cs.stage3.alice.core.question.UnaryBooleanResultingInBooleanQuestion"),
	("a", "edu.cmu.cs.stage3.alice.core.question.UnaryNumberResultingInBooleanQuestion"),
	("a", "edu.cmu.cs.stage3.alice.core.question.UnaryNumberResultingInNumberQuestion"),
	("owner", "edu.cmu.cs.stage3.alice.core.question.PartKeyed"),
	("key", "edu.cmu.cs.stage3.alice.core.question.PartKeyed"),
	("owner", "edu.cmu.cs.stage3.alice.core.question.VariableNamed"),
	("variableName", "edu.cmu.cs.stage3.alice.core.question.VariableNamed"),
	("valueClass", "edu.cmu.cs.stage3.alice.core.question.VariableNamed"),
	("threshold", "edu.cmu.cs.stage3.alice.core.question.IsCloseTo"),
	("threshold", "edu.cmu.cs.stage3.alice.core.question.IsFarFrom"),
	("emissiveColorMap", "edu.cmu.cs.stage3.alice.core.Model"),
	("specularHighlightColorMap", "edu.cmu.cs.stage3.alice.core.Model"),
	("bumpMap", "edu.cmu.cs.stage3.alice.core.Model"),
	("detailMap", "edu.cmu.cs.stage3.alice.core.Model"),
	("interactionMap", "edu.cmu.cs.stage3.alice.core.Model"),
	("disabledAffectors", "edu.cmu.cs.stage3.alice.core.Model"),
	("transformable", "edu.cmu.cs.stage3.alice.core.behavior.KeyboardNavigationBehavior"),
	("a", "edu.cmu.cs.stage3.alice.core.question.StringConcatQuestion"),
	("b", "edu.cmu.cs.stage3.alice.core.question.StringConcatQuestion"),
	("what", "edu.cmu.cs.stage3.alice.core.question.ToStringQuestion"),

	("list", "edu.cmu.cs.stage3.alice.core.question.list.Contains"),
	("item", "edu.cmu.cs.stage3.alice.core.question.list.Contains"),
	("list", "edu.cmu.cs.stage3.alice.core.question.list.FirstIndexOfItem"),
	("item", "edu.cmu.cs.stage3.alice.core.question.list.FirstIndexOfItem"),
	("list", "edu.cmu.cs.stage3.alice.core.question.list.IsEmpty"),
	("list", "edu.cmu.cs.stage3.alice.core.question.list.ItemAtBeginning"),
	("list", "edu.cmu.cs.stage3.alice.core.question.list.ItemAtEnd"),
	("list", "edu.cmu.cs.stage3.alice.core.question.list.ItemAtIndex"),
	("index", "edu.cmu.cs.stage3.alice.core.question.list.ItemAtIndex"),
	("list", "edu.cmu.cs.stage3.alice.core.question.list.ItemAtRandomIndex"),
	("list", "edu.cmu.cs.stage3.alice.core.question.list.LastIndexOfItem"),
	("item", "edu.cmu.cs.stage3.alice.core.question.list.LastIndexOfItem"),
	("list", "edu.cmu.cs.stage3.alice.core.question.list.Size"),
	("value", "edu.cmu.cs.stage3.alice.core.question.userdefined.Return"),

	("array", "edu.cmu.cs.stage3.alice.core.question.array.ItemAtIndex"),
	("index", "edu.cmu.cs.stage3.alice.core.question.array.ItemAtIndex"),
	("array", "edu.cmu.cs.stage3.alice.core.question.array.Size"),
	("element", "edu.cmu.cs.stage3.alice.core.question.PropertyValue"),
	

]

defaultPropertyValues = [
["edu.cmu.cs.stage3.alice.core.question.visualization.array.ItemAtIndex",
	["index",
		Double( 0.0 ),
		Double( 1.0 ),
		Double( 2.0 ),
		Double( 3.0 ),
	],
],
["edu.cmu.cs.stage3.alice.core.question.visualization.list.ItemAtIndex",
	["index",
		Double( 0.0 ),
		Double( 1.0 ),
		Double( 2.0 ),
		Double( 3.0 ),
	],
],
["edu.cmu.cs.stage3.alice.core.response.visualization.array.SetItemAtIndex",
	["index",
		Double( 0.0 ),
		Double( 1.0 ),
		Double( 2.0 ),
		Double( 3.0 ),
	],
],
["edu.cmu.cs.stage3.alice.core.response.visualization.list.InsertItemAtIndex",
	["index",
		Double( 0.0 ),
		Double( 1.0 ),
		Double( 2.0 ),
		Double( 3.0 ),
	],
],
["edu.cmu.cs.stage3.alice.core.response.visualization.list.RemoveItemFromIndex",
	["index",
		Double( 0.0 ),
		Double( 1.0 ),
		Double( 2.0 ),
		Double( 3.0 ),
	],
],
["edu.cmu.cs.stage3.alice.core.Transformable",
	["localTransformation",
		Matrix44.IDENTITY,
	]
],
["edu.cmu.cs.stage3.alice.core.Model",
	["opacity",
		Double( 0.0 ),
		Double( 0.1 ),
		Double( 0.2 ),
		Double( 0.3 ),
		Double( 0.4 ),
		Double( 0.5 ),
		Double( 0.6 ),
		Double( 0.7 ),
		Double( 0.8 ),
		Double( 0.9 ),
		Double( 1.0 ),
	],
	["specularHighlightExponent",
		Double( 0.0 ),
		Double( 0.1 ),
		Double( 1.0 ),
		Double( 3.0 ),
		Double( 5.0 ),
		Double( 10.0 ),
		Double( 20.0 ),
		Double( 50.0 ),
		Double( 100.0 ),
	]
],
["edu.cmu.cs.stage3.alice.core.response.LoopNInOrder",
	["start",
		Double( 0 ),
		Double( 1 ),
		Double( 2 ),
		Double( 5 ),
		Double( 10 ),
	]
],
["edu.cmu.cs.stage3.alice.core.response.LoopNInOrder",
	["end",
		Double( 1 ),
		Double( 2 ),
		Double( 5 ),
		Double( 10 ),
		Double( Double.POSITIVE_INFINITY ),
	]
],
["edu.cmu.cs.stage3.alice.core.response.LoopNInOrder",
	["increment",
		Double( 1 ),
		Double( 2 ),
		Double( 5 ),
		Double( 10 ),
	]
],
["edu.cmu.cs.stage3.alice.core.question.userdefined.LoopN",
	["start",
		Double( 0 ),
		Double( 1 ),
		Double( 2 ),
		Double( 5 ),
		Double( 10 ),
	]
],
["edu.cmu.cs.stage3.alice.core.question.userdefined.LoopN",
	["end",
		Double( 1 ),
		Double( 2 ),
		Double( 5 ),
		Double( 10 ),
		Double( Double.POSITIVE_INFINITY ),
	]
],
["edu.cmu.cs.stage3.alice.core.question.userdefined.LoopN",
	["increment",
		Double( 1 ),
		Double( 2 ),
		Double( 5 ),
		Double( 10 ),
	]
],
["edu.cmu.cs.stage3.alice.core.response.SendMessage",
	["message",
		String( "ping" ),
	]
],
["edu.cmu.cs.stage3.alice.core.response.SayAnimation",
	["what",
		String( "Hello" ),
		String( "Goodbye" ),
	]
],
["edu.cmu.cs.stage3.alice.core.response.ThinkAnimation",
	["what",
		String( "I wonder" ),
	]
],
["edu.cmu.cs.stage3.alice.core.response.AbstractBubbleAnimation",
	["fontSize",
		Integer( 20 ),
		Integer( 25 ),
		Integer( 30 ),
	]
],
["edu.cmu.cs.stage3.alice.core.response.MoveAnimation",
	["amount",
		Double( .5 ),
		Double( 1 ),
		Double( 5 ),
		Double( 10 ),
	]
],
["edu.cmu.cs.stage3.alice.core.response.ResizeAnimation",
	["amount",
		Double( .5 ),
		Double( 2 ),
	]
],
["edu.cmu.cs.stage3.alice.core.response.MoveAtSpeed",
	["speed",
		Double( .5 ),
		Double( 1 ),
		Double( 5 ),
		Double( 10 ),
	]
],
["edu.cmu.cs.stage3.alice.core.response.RotateAnimation",
	["amount",
		Double( .25 ),
		Double( .5 ),
		Double( 1 ),
		Double( 2 ),
	]
],
["edu.cmu.cs.stage3.alice.core.response.RotateAtSpeed",
	["speed",
		Double( .25 ),
		Double( .5 ),
		Double( 1 ),
		Double( 2 ),
	]
],
["edu.cmu.cs.stage3.alice.core.response.TurnAnimation",
	["direction",
		edu.cmu.cs.stage3.alice.core.Direction.LEFT,
		edu.cmu.cs.stage3.alice.core.Direction.RIGHT,
		edu.cmu.cs.stage3.alice.core.Direction.FORWARD,
		edu.cmu.cs.stage3.alice.core.Direction.BACKWARD,
	]
],
["edu.cmu.cs.stage3.alice.core.response.TurnAtSpeed",
	["direction",
		edu.cmu.cs.stage3.alice.core.Direction.LEFT,
		edu.cmu.cs.stage3.alice.core.Direction.RIGHT,
		edu.cmu.cs.stage3.alice.core.Direction.FORWARD,
		edu.cmu.cs.stage3.alice.core.Direction.BACKWARD,
	]
],
["edu.cmu.cs.stage3.alice.core.response.RollAnimation",
	["direction",
		edu.cmu.cs.stage3.alice.core.Direction.LEFT,
		edu.cmu.cs.stage3.alice.core.Direction.RIGHT,
	]
],
["edu.cmu.cs.stage3.alice.core.response.RollAtSpeed",
	["direction",
		edu.cmu.cs.stage3.alice.core.Direction.LEFT,
		edu.cmu.cs.stage3.alice.core.Direction.RIGHT,
	]
],
["edu.cmu.cs.stage3.alice.core.response.MoveAnimation",
	["amount",
		Double( .25 ),
		Double( .5 ),
		Double( 2 ),
		Double( 4 ),
	]
],
["edu.cmu.cs.stage3.alice.core.response.PositionAnimation",
	["position",
		Vector3( 0.0, 0.0, 0.0 ),
	]
],
["edu.cmu.cs.stage3.alice.core.response.PointOfViewAnimation",
	["pointOfView",
		Matrix44.IDENTITY,
	]
],
["javax.vecmath.Matrix4d",
	["value",
		Matrix44.IDENTITY,
	]
],
["edu.cmu.cs.stage3.alice.core.response.DirectionAmountTransformAnimation",
	["direction",
		edu.cmu.cs.stage3.alice.core.Direction.UP,
		edu.cmu.cs.stage3.alice.core.Direction.DOWN,
		edu.cmu.cs.stage3.alice.core.Direction.LEFT,
		edu.cmu.cs.stage3.alice.core.Direction.RIGHT,
		edu.cmu.cs.stage3.alice.core.Direction.FORWARD,
		edu.cmu.cs.stage3.alice.core.Direction.BACKWARD,
	]
],
["edu.cmu.cs.stage3.alice.core.response.DirectionSpeedTransformResponse",
	["direction",
		edu.cmu.cs.stage3.alice.core.Direction.UP,
		edu.cmu.cs.stage3.alice.core.Direction.DOWN,
		edu.cmu.cs.stage3.alice.core.Direction.LEFT,
		edu.cmu.cs.stage3.alice.core.Direction.RIGHT,
		edu.cmu.cs.stage3.alice.core.Direction.FORWARD,
		edu.cmu.cs.stage3.alice.core.Direction.BACKWARD,
	]
],
["edu.cmu.cs.stage3.alice.core.behavior.KeyClickBehavior",
	["keyCode",
		java.awt.event.KeyEvent.VK_SPACE,
		java.awt.event.KeyEvent.VK_ENTER,
		java.awt.event.KeyEvent.VK_UP,
		java.awt.event.KeyEvent.VK_DOWN,
		java.awt.event.KeyEvent.VK_LEFT,
		java.awt.event.KeyEvent.VK_RIGHT,
		java.awt.event.KeyEvent.VK_ALT,
		java.awt.event.KeyEvent.VK_CONTROL,
		java.awt.event.KeyEvent.VK_SHIFT,
		["letters",
			java.awt.event.KeyEvent.VK_A,
			java.awt.event.KeyEvent.VK_B,
			java.awt.event.KeyEvent.VK_C,
			java.awt.event.KeyEvent.VK_D,
			java.awt.event.KeyEvent.VK_E,
			java.awt.event.KeyEvent.VK_F,
			java.awt.event.KeyEvent.VK_G,
			java.awt.event.KeyEvent.VK_H,
			java.awt.event.KeyEvent.VK_I,
			java.awt.event.KeyEvent.VK_J,
			java.awt.event.KeyEvent.VK_K,
			java.awt.event.KeyEvent.VK_L,
			java.awt.event.KeyEvent.VK_M,
			java.awt.event.KeyEvent.VK_N,
			java.awt.event.KeyEvent.VK_O,
			java.awt.event.KeyEvent.VK_P,
			java.awt.event.KeyEvent.VK_Q,
			java.awt.event.KeyEvent.VK_R,
			java.awt.event.KeyEvent.VK_S,
			java.awt.event.KeyEvent.VK_T,
			java.awt.event.KeyEvent.VK_U,
			java.awt.event.KeyEvent.VK_V,
			java.awt.event.KeyEvent.VK_W,
			java.awt.event.KeyEvent.VK_X,
			java.awt.event.KeyEvent.VK_Y,
			java.awt.event.KeyEvent.VK_Z,
		],
		["numbers",
			java.awt.event.KeyEvent.VK_0,
			java.awt.event.KeyEvent.VK_1,
			java.awt.event.KeyEvent.VK_2,
			java.awt.event.KeyEvent.VK_3,
			java.awt.event.KeyEvent.VK_4,
			java.awt.event.KeyEvent.VK_5,
			java.awt.event.KeyEvent.VK_6,
			java.awt.event.KeyEvent.VK_7,
			java.awt.event.KeyEvent.VK_8,
			java.awt.event.KeyEvent.VK_9,
		],
		["numpad",
			java.awt.event.KeyEvent.VK_NUMPAD0,
			java.awt.event.KeyEvent.VK_NUMPAD1,
			java.awt.event.KeyEvent.VK_NUMPAD2,
			java.awt.event.KeyEvent.VK_NUMPAD3,
			java.awt.event.KeyEvent.VK_NUMPAD4,
			java.awt.event.KeyEvent.VK_NUMPAD5,
			java.awt.event.KeyEvent.VK_NUMPAD6,
			java.awt.event.KeyEvent.VK_NUMPAD7,
			java.awt.event.KeyEvent.VK_NUMPAD8,
			java.awt.event.KeyEvent.VK_NUMPAD9,
			java.awt.event.KeyEvent.VK_DIVIDE,
			java.awt.event.KeyEvent.VK_MULTIPLY,
			java.awt.event.KeyEvent.VK_SUBTRACT,
			java.awt.event.KeyEvent.VK_ADD,
		],
		["symbols",
			java.awt.event.KeyEvent.VK_BACK_QUOTE,
			java.awt.event.KeyEvent.VK_MINUS,	
			java.awt.event.KeyEvent.VK_EQUALS,
			java.awt.event.KeyEvent.VK_OPEN_BRACKET,
			java.awt.event.KeyEvent.VK_CLOSE_BRACKET,
			java.awt.event.KeyEvent.VK_BACK_SLASH,
			java.awt.event.KeyEvent.VK_SEMICOLON,
			java.awt.event.KeyEvent.VK_QUOTE,
			java.awt.event.KeyEvent.VK_COMMA,
			java.awt.event.KeyEvent.VK_PERIOD,
			java.awt.event.KeyEvent.VK_SLASH,
		],
	],
],
["edu.cmu.cs.stage3.alice.core.behavior.KeyIsPressedBehavior",
	["keyCode",
		java.awt.event.KeyEvent.VK_SPACE,
		java.awt.event.KeyEvent.VK_ENTER,
		java.awt.event.KeyEvent.VK_UP,
		java.awt.event.KeyEvent.VK_DOWN,
		java.awt.event.KeyEvent.VK_LEFT,
		java.awt.event.KeyEvent.VK_RIGHT,
		java.awt.event.KeyEvent.VK_ALT,
		java.awt.event.KeyEvent.VK_CONTROL,
		java.awt.event.KeyEvent.VK_SHIFT,
		["letters",
			java.awt.event.KeyEvent.VK_A,
			java.awt.event.KeyEvent.VK_B,
			java.awt.event.KeyEvent.VK_C,
			java.awt.event.KeyEvent.VK_D,
			java.awt.event.KeyEvent.VK_E,
			java.awt.event.KeyEvent.VK_F,
			java.awt.event.KeyEvent.VK_G,
			java.awt.event.KeyEvent.VK_H,
			java.awt.event.KeyEvent.VK_I,
			java.awt.event.KeyEvent.VK_J,
			java.awt.event.KeyEvent.VK_K,
			java.awt.event.KeyEvent.VK_L,
			java.awt.event.KeyEvent.VK_M,
			java.awt.event.KeyEvent.VK_N,
			java.awt.event.KeyEvent.VK_O,
			java.awt.event.KeyEvent.VK_P,
			java.awt.event.KeyEvent.VK_Q,
			java.awt.event.KeyEvent.VK_R,
			java.awt.event.KeyEvent.VK_S,
			java.awt.event.KeyEvent.VK_T,
			java.awt.event.KeyEvent.VK_U,
			java.awt.event.KeyEvent.VK_V,
			java.awt.event.KeyEvent.VK_W,
			java.awt.event.KeyEvent.VK_X,
			java.awt.event.KeyEvent.VK_Y,
			java.awt.event.KeyEvent.VK_Z,
		],
		["numbers",
			java.awt.event.KeyEvent.VK_0,
			java.awt.event.KeyEvent.VK_1,
			java.awt.event.KeyEvent.VK_2,
			java.awt.event.KeyEvent.VK_3,
			java.awt.event.KeyEvent.VK_4,
			java.awt.event.KeyEvent.VK_5,
			java.awt.event.KeyEvent.VK_6,
			java.awt.event.KeyEvent.VK_7,
			java.awt.event.KeyEvent.VK_8,
			java.awt.event.KeyEvent.VK_9,
		],
		["numpad",
			java.awt.event.KeyEvent.VK_NUMPAD0,
			java.awt.event.KeyEvent.VK_NUMPAD1,
			java.awt.event.KeyEvent.VK_NUMPAD2,
			java.awt.event.KeyEvent.VK_NUMPAD3,
			java.awt.event.KeyEvent.VK_NUMPAD4,
			java.awt.event.KeyEvent.VK_NUMPAD5,
			java.awt.event.KeyEvent.VK_NUMPAD6,
			java.awt.event.KeyEvent.VK_NUMPAD7,
			java.awt.event.KeyEvent.VK_NUMPAD8,
			java.awt.event.KeyEvent.VK_NUMPAD9,
			java.awt.event.KeyEvent.VK_DIVIDE,
			java.awt.event.KeyEvent.VK_MULTIPLY,
			java.awt.event.KeyEvent.VK_SUBTRACT,
			java.awt.event.KeyEvent.VK_ADD,
		],
		["symbols",
			java.awt.event.KeyEvent.VK_BACK_QUOTE,
			java.awt.event.KeyEvent.VK_MINUS,	
			java.awt.event.KeyEvent.VK_EQUALS,
			java.awt.event.KeyEvent.VK_OPEN_BRACKET,
			java.awt.event.KeyEvent.VK_CLOSE_BRACKET,
			java.awt.event.KeyEvent.VK_BACK_SLASH,
			java.awt.event.KeyEvent.VK_SEMICOLON,
			java.awt.event.KeyEvent.VK_QUOTE,
			java.awt.event.KeyEvent.VK_COMMA,
			java.awt.event.KeyEvent.VK_PERIOD,
			java.awt.event.KeyEvent.VK_SLASH,
		],
	],
],
["edu.cmu.cs.stage3.alice.core.question.PartKeyed",
	["key",
		"replace me",
	]
],
["edu.cmu.cs.stage3.alice.core.question.VariableNamed",
	["variableName",
		"replace me",
	],
	["valueClass",
		java.lang.Boolean,
		java.lang.Number,
		edu.cmu.cs.stage3.alice.core.Model,
	]
],
["edu.cmu.cs.stage3.alice.core.question.IsCloseTo",
	["threshold",
		Double( 1 ),
		Double( 2 ),
		Double( 5 ),
		Double( 10 ),
	]
],
["edu.cmu.cs.stage3.alice.core.question.IsFarFrom",
	["threshold",
		Double( 1 ),
		Double( 2 ),
		Double( 5 ),
		Double( 10 ),
	]
],
["edu.cmu.cs.stage3.alice.core.question.RandomBoolean",
	["probabilityOfTrue",
		Double( 0.0 ),
		Double( .1 ),
		Double( .2 ),
		Double( .3 ),
		Double( .4 ),
		Double( .5 ),
		Double( .6 ),
		Double( .7 ),
		Double( .8 ),
		Double( .9 ),
		Double( 1.0 ),
	]
],
["edu.cmu.cs.stage3.alice.core.question.RandomNumber",
	["minimum",
		Double( 0.0 ),
		Double( 1.0 ),
		Double( 5.0 ),
		Double( 10.0 ),
		Double( 50.0 ),
		Double( 100.0 ),
	],
	["maximum",
		Double( 0.0 ),
		Double( 1.0 ),
		Double( 5.0 ),
		Double( 10.0 ),
		Double( 50.0 ),
		Double( 100.0 ),
	],
],
["edu.cmu.cs.stage3.alice.core.question.list.ItemAtIndex",
	["index",
		Double( 0.0 ),
		Double( 1.0 ),
		Double( 2.0 ),
		Double( 3.0 ),
	],
],
["edu.cmu.cs.stage3.alice.core.response.list.InsertItemAtIndex",
	["index",
		Double( 0.0 ),
		Double( 1.0 ),
		Double( 2.0 ),
		Double( 3.0 ),
	],
],
["edu.cmu.cs.stage3.alice.core.response.list.RemoveItemFromIndex",
	["index",
		Double( 0.0 ),
		Double( 1.0 ),
		Double( 2.0 ),
		Double( 3.0 ),
	],
],
["edu.cmu.cs.stage3.alice.core.question.array.ItemAtIndex",
	["index",
		Double( 0.0 ),
		Double( 1.0 ),
		Double( 2.0 ),
		Double( 3.0 ),
	],
],
["edu.cmu.cs.stage3.alice.core.response.array.SetItemAtIndex",
	["index",
		Double( 0.0 ),
		Double( 1.0 ),
		Double( 2.0 ),
		Double( 3.0 ),
	],
],
["edu.cmu.cs.stage3.alice.core.behavior.SoundLevelBehavior",
	["level",
		Double( 0.0 ),
		Double( .1 ),
		Double( .2 ),
		Double( .3 ),
		Double( .4 ),
		Double( .5 ),
		Double( .6 ),
		Double( .7 ),
		Double( .8 ),
		Double( .9 ),
		Double( 1.0 ),
	]
],
["edu.cmu.cs.stage3.alice.core.question.ask.AskUserForNumber",
	["title",
		"Question",
	],
	["question",
		"Enter a Number:",
	],
],
["edu.cmu.cs.stage3.alice.core.question.ask.AskUserYesNo",
	["title",
		"Question",
	],
	["question",
		"Yes or No?",
	],
],
["edu.cmu.cs.stage3.alice.core.question.ask.AskUserForString",
	["title",
		"Question",
	],
	["question",
		"Enter a String:",
	],
],
]

propertiesToOmitScriptDefinedFor = [
	("triggerResponse", "edu.cmu.cs.stage3.alice.core.behavior.TriggerBehavior"),
	("beginResponse", "edu.cmu.cs.stage3.alice.core.behavior.ConditionalBehavior"),
	("duringResponse", "edu.cmu.cs.stage3.alice.core.behavior.ConditionalBehavior"),
	("endResponse", "edu.cmu.cs.stage3.alice.core.behavior.ConditionalBehavior"),
	("script", "edu.cmu.cs.stage3.alice.core.response.ScriptResponse"),
	("script", "edu.cmu.cs.stage3.alice.core.response.ScriptDefinedResponse"),
	("text", "edu.cmu.cs.stage3.alice.core.response.Comment"),
]


propertyValueFormatMap = {
	"edu.cmu.cs.stage3.alice.core.Behavior.isEnabled" : {
		Boolean.TRUE : "enabled",
		Boolean.FALSE : "disabled",
		"default" : "<value>",
	},
	"edu.cmu.cs.stage3.alice.core.Camera.nearClippingPlaneDistance" : {
		Double( 1.0 ) : "<value> <distanceUnit>",
		"default" : "<value> <distanceUnits>",
	},
	"edu.cmu.cs.stage3.alice.core.Camera.farClippingPlaneDistance" : {
		Double( 1.0 ) : "<value> <distanceUnit>",
		"default" : "<value> <distanceUnits>",
	},
	"edu.cmu.cs.stage3.alice.core.Light.range" : {
		Double( 1.0 ) : "<value> <distanceUnit>",
		"default" : "<value> <distanceUnits>",
	},
	"edu.cmu.cs.stage3.alice.core.Model.opacity" : {
		Double( 0.0 ) : "<value> (<percentValue>)",
		Double( 1.0 ) : "<value> (<percentValue>)",
		"default" : "<value> (<percentValue>)",
	},
	"edu.cmu.cs.stage3.alice.core.Model.opacity.menuContext" : { # for values shown in a menu
		Double( 0.0 ) : "<value> (<percentValue> : invisible)",
		Double( 1.0 ) : "<value> (<percentValue> : fully opaque)",
		"default" : "<value> (<percentValue>)",
	},
	"edu.cmu.cs.stage3.alice.core.Response.duration" : {
		Double( 1.0 ) : "<value> <timeUnit>",
		"default" : "<value> <timeUnits>",
	},
	"edu.cmu.cs.stage3.alice.core.World.fogNearDistance" : {
		Double( 1.0 ) : "<value> <distanceUnit>",
		"default" : "<value> <distanceUnits>",
	},
	"edu.cmu.cs.stage3.alice.core.World.fogFarDistance" : {
		Double( 1.0 ) : "<value> <distanceUnit>",
		"default" : "<value> <distanceUnits>",
	},
	"edu.cmu.cs.stage3.alice.core.behavior.TriggerBehavior.triggerResponse" : {
		None : "Nothing",
		"default" : "<value>",
	},
	"edu.cmu.cs.stage3.alice.core.behavior.ConditionalBehavior.beginResponse" : {
		None : "Nothing",
		"default" : "<value>",
	},
	"edu.cmu.cs.stage3.alice.core.behavior.ConditionalBehavior.duringResponse" : {
		None : "Nothing",
		"default" : "<value>",
	},
	"edu.cmu.cs.stage3.alice.core.behavior.ConditionalBehavior.endResponse" : {
		None : "Nothing",
		"default" : "<value>",
	},
	"edu.cmu.cs.stage3.alice.core.behavior.KeyClickBehavior.keyCode" : {
		None : "any key",
		"default" : "<keyCodeValue>",
	},
	"edu.cmu.cs.stage3.alice.core.behavior.KeyIsPressedBehavior.keyCode" : {
		None : "any key",
		"default" : "<keyCodeValue>",
	},
	"edu.cmu.cs.stage3.alice.core.behavior.MouseButtonClickBehavior.onWhat" : {
		None : "anything",
		"default" : "<value>",
	},
	"edu.cmu.cs.stage3.alice.core.behavior.MouseButtonIsPressedBehavior.onWhat" : {
		None : "anything",
		"default" : "<value>",
	},
	"edu.cmu.cs.stage3.alice.core.light.SpotLight.innerBeamAngle" : {
		"default" : "<value> <angleUnits>",
	},
	"edu.cmu.cs.stage3.alice.core.light.SpotLight.outerBeamAngle" : {
		"default" : "<value> <angleUnits>",
	},
	"edu.cmu.cs.stage3.alice.core.question.IsCloseTo.threshold" : {
		Double( 1.0 ) : "<value> <distanceUnit>",
		"default" : "<value> <distanceUnits>",
	},
	"edu.cmu.cs.stage3.alice.core.question.IsFarFrom.threshold" : {
		Double( 1.0 ) : "<value> <distanceUnit>",
		"default" : "<value> <distanceUnits>",
	},
	"edu.cmu.cs.stage3.alice.core.response.LoopNInOrder.end" : {
		Double( 1.0 ) : "<value> <countUnit>",
		Double( Double.POSITIVE_INFINITY ) : "infinity <countUnits>",
		"default" : "<value> <countUnits>",
	},
	"edu.cmu.cs.stage3.alice.core.question.userdefined.LoopN.end" : {
		Double( 1.0 ) : "<value> <countUnit>",
		Double( Double.POSITIVE_INFINITY ) : "infinity <countUnits>",
		"default" : "<value> <countUnits>",
	},
	"edu.cmu.cs.stage3.alice.core.response.MoveAnimation.amount" : {
		Double( 1.0 ) : "<value> <distanceUnit>",
		"default" : "<value> <distanceUnits>",
	},
	"edu.cmu.cs.stage3.alice.core.response.MoveAnimation.amount.menuContext" : {  # for values shown in a menu
		Double( .25 ) : "1/4 <distanceUnit>",
		Double( .5 ) : "1/2 <distanceUnit>",
		Double( .75 ) : "3/4 <distanceUnit>",
		Double( 1.0 ) : "1 <distanceUnit>",
		"default" : "<value> <distanceUnits>",
	},
	"edu.cmu.cs.stage3.alice.core.response.ResizeAnimation.amount.menuContext" : {  # for values shown in a menu
		Double( .5 ) : "1/2 (half as big)",
		Double( 2.0 ) : "2 (twice as big)",
		"default" : "<value>",
	},
	"edu.cmu.cs.stage3.alice.core.response.MoveAwayFromAnimation.amount" : {
		Double( 1.0 ) : "<value> <distanceUnit>",
		"default" : "<value> <distanceUnits>",
	},
	"edu.cmu.cs.stage3.alice.core.response.MoveAwayFromAnimation.amount.menuContext" : {  # for values shown in a menu
		Double( .25 ) : "1/4 <distanceUnit>",
		Double( .5 ) : "1/2 <distanceUnit>",
		Double( .75 ) : "3/4 <distanceUnit>",
		Double( 1.0 ) : "1 <distanceUnit>",
		"default" : "<value> <distanceUnits>",
	},
	"edu.cmu.cs.stage3.alice.core.response.MoveTowardAnimation.amount" : {
		Double( 1.0 ) : "<value> <distanceUnit>",
		"default" : "<value> <distanceUnits>",
	},
	"edu.cmu.cs.stage3.alice.core.response.MoveTowardAnimation.amount.menuContext" : {  # for values shown in a menu
		Double( .25 ) : "1/4 <distanceUnit>",
		Double( .5 ) : "1/2 <distanceUnit>",
		Double( .75 ) : "3/4 <distanceUnit>",
		Double( 1.0 ) : "1 <distanceUnit>",
		"default" : "<value> <distanceUnits>",
	},
	"edu.cmu.cs.stage3.alice.core.response.MoveAtSpeed.speed" : {
		Double( 1.0 ) : "<value> <distanceVelocityUnit>",
		"default" : "<value> <distanceVelocityUnits>",
	},
	"edu.cmu.cs.stage3.alice.core.response.MoveAtSpeed.speed.menuContext" : {  # for values shown in a menu
		Double( .25 ) : "1/4 <distanceVelocityUnit>",
		Double( .5 ) : "1/2 <distanceVelocityUnit>",
		Double( .75 ) : "3/4 <distanceVelocityUnit>",
		Double( 1.0 ) : "1 <distanceVelocityUnit>",
		"default" : "<value> <distanceVelocityUnits>",
	},
	"edu.cmu.cs.stage3.alice.core.response.RotateAnimation.amount" : {
		Double( 1.0 ) : "<value> <revolutionUnit>",
		"default" : "<value> <revolutionUnits>",
	},
	"edu.cmu.cs.stage3.alice.core.response.RotateAnimation.amount.menuContext" : {  # for values shown in a menu
		Double( .25 ) : "1/4 <revolutionUnit>",
		Double( .5 ) : "1/2 <revolutionUnit>",
		Double( .75 ) : "3/4 <revolutionUnit>",
		Double( 1.0 ) : "1 <revolutionUnit> (all the way around)",
		"default" : "<value> <revolutionUnits>",
	},
	"edu.cmu.cs.stage3.alice.core.response.RotateAtSpeed.speed" : {
		"default" : "<value> <revolutionVelocityUnits>",
	},
	"edu.cmu.cs.stage3.alice.core.behavior.SoundLevelBehavior.level" : {
		"default" : "<value> (<percentValue>)",
	},
	"edu.cmu.cs.stage3.alice.core.behavior.DefaultMouseInteractionBehavior.objects" : {
		None : "Any Object",
	},
	"edu.cmu.cs.stage3.alice.core.response.SoundResponse.duration" : {
		None : "Full Length",
	},
	"edu.cmu.cs.stage3.alice.core.response.SoundResponse.fromMarker" : {
		None : "Start of Sound",
	},
	"edu.cmu.cs.stage3.alice.core.response.SoundResponse.toMarker" : {
		None : "End of Sound",
	},
	"edu.cmu.cs.stage3.alice.core.question.RandomBoolean.probabilityOfTrue" : {
		"default" : "<value> (<percentValue>)",
	},
}

unitMap = {
	"distanceUnit" : "meter",
	"distanceUnits" : "meters",
	"timeUnit" : "second",
	"timeUnits" : "seconds",
	"angleUnit" : "radian",
	"angleUnits" : "radians",
	"countUnit" : "time",
	"countUnits" : "times",
	"distanceVelocityUnit" : "meter per second",
	"distanceVelocityUnits" : "meters per second",
	"revolutionUnit" : "revolution",
	"revolutionUnits" : "revolutions",
	"revolutionVelocityUnit" : "revolution per second",
	"revolutionVelocityUnits" : "revolutions per second",
}


worldTreeChildrenProperties = [
["edu.cmu.cs.stage3.alice.core.World",
	"sandboxes",
	"groups",
],
["edu.cmu.cs.stage3.alice.core.Transformable",
	"parts",
],
["edu.cmu.cs.stage3.alice.core.Group",
	"values",
],
]


parameterizedPropertiesToOmit = [
	"name",
	"parent",
	"author",
	"isFirstClass",
	"data",
	"requiredActualParameters",
	"keywordActualParameters",
	"requiredFormalParameters",
	"keywordFormalParameters",
	"localVariables",
	"anonymous",
	"isCommentedOut",
	"ignoreCase",
	"valueClass",
	"pan",
	"rate",
]


######################
# Response Config
######################

oneShotGroupsToInclude = [
	"common animations",
	"communication animations",
	"advanced animations",
	"property animations",
]

oneShotStructure = [
["edu.cmu.cs.stage3.alice.core.visualization.ModelVisualization",
	["common animations",
		"edu.cmu.cs.stage3.alice.core.response.visualization.model.SetItem",
		
		"edu.cmu.cs.stage3.alice.core.response.MoveAnimation",
		"edu.cmu.cs.stage3.alice.core.response.TurnAnimation",
		"edu.cmu.cs.stage3.alice.core.response.RollAnimation",
		"edu.cmu.cs.stage3.alice.core.response.ResizeAnimation",
		"edu.cmu.cs.stage3.alice.core.response.TurnToFaceAnimation",
		"edu.cmu.cs.stage3.alice.core.response.PointAtAnimation",
		"edu.cmu.cs.stage3.alice.core.response.StandUpAnimation",
		"edu.cmu.cs.stage3.alice.core.response.PositionAnimation",
		"edu.cmu.cs.stage3.alice.core.response.QuaternionAnimation",
		"edu.cmu.cs.stage3.alice.core.response.PointOfViewAnimation",
		"edu.cmu.cs.stage3.alice.core.response.SoundResponse",
#		"edu.cmu.cs.stage3.alice.core.response.SendMessage",
		"edu.cmu.cs.stage3.alice.core.response.PoseAnimation",
		"edu.cmu.cs.stage3.alice.core.response.SayAnimation",
		"edu.cmu.cs.stage3.alice.core.response.MoveTowardAnimation",
		"edu.cmu.cs.stage3.alice.core.response.MoveAwayFromAnimation",
		["property animations",
			"edu.cmu.cs.stage3.alice.core.response.PropertyAnimation<color>",
			"edu.cmu.cs.stage3.alice.core.response.PropertyAnimation<opacity>",
			"edu.cmu.cs.stage3.alice.core.response.PropertyAnimation<vehicle>",
			"edu.cmu.cs.stage3.alice.core.response.PropertyAnimation<diffuseColorMap>",
			"edu.cmu.cs.stage3.alice.core.response.PropertyAnimation<fillingStyle>",
		],
	],
	
	["at speed animations",
		"edu.cmu.cs.stage3.alice.core.response.MoveAtSpeed",
		"edu.cmu.cs.stage3.alice.core.response.TurnAtSpeed",
		"edu.cmu.cs.stage3.alice.core.response.RollAtSpeed",
	],
	["constraints",
		"edu.cmu.cs.stage3.alice.core.response.TurnToFaceConstraint",
		"edu.cmu.cs.stage3.alice.core.response.PointAtConstraint",
	],
],
["edu.cmu.cs.stage3.alice.core.visualization.ArrayOfModelsVisualization",
	["common animations",
		"edu.cmu.cs.stage3.alice.core.response.visualization.array.SetItemAtIndex",
		
		"edu.cmu.cs.stage3.alice.core.response.MoveAnimation",
		"edu.cmu.cs.stage3.alice.core.response.TurnAnimation",
		"edu.cmu.cs.stage3.alice.core.response.RollAnimation",
		"edu.cmu.cs.stage3.alice.core.response.ResizeAnimation",
		"edu.cmu.cs.stage3.alice.core.response.TurnToFaceAnimation",
		"edu.cmu.cs.stage3.alice.core.response.PointAtAnimation",
		"edu.cmu.cs.stage3.alice.core.response.StandUpAnimation",
		"edu.cmu.cs.stage3.alice.core.response.PositionAnimation",
		"edu.cmu.cs.stage3.alice.core.response.QuaternionAnimation",
		"edu.cmu.cs.stage3.alice.core.response.PointOfViewAnimation",
		"edu.cmu.cs.stage3.alice.core.response.SoundResponse",
#		"edu.cmu.cs.stage3.alice.core.response.SendMessage",
		"edu.cmu.cs.stage3.alice.core.response.PoseAnimation",
		"edu.cmu.cs.stage3.alice.core.response.SayAnimation",
		"edu.cmu.cs.stage3.alice.core.response.MoveTowardAnimation",
		"edu.cmu.cs.stage3.alice.core.response.MoveAwayFromAnimation",
		["property animations",
			"edu.cmu.cs.stage3.alice.core.response.PropertyAnimation<color>",
			"edu.cmu.cs.stage3.alice.core.response.PropertyAnimation<opacity>",
			"edu.cmu.cs.stage3.alice.core.response.PropertyAnimation<vehicle>",
			"edu.cmu.cs.stage3.alice.core.response.PropertyAnimation<diffuseColorMap>",
			"edu.cmu.cs.stage3.alice.core.response.PropertyAnimation<fillingStyle>",
		],
	],
	["at speed animations",
		"edu.cmu.cs.stage3.alice.core.response.MoveAtSpeed",
		"edu.cmu.cs.stage3.alice.core.response.TurnAtSpeed",
		"edu.cmu.cs.stage3.alice.core.response.RollAtSpeed",
	],
	["constraints",
		"edu.cmu.cs.stage3.alice.core.response.TurnToFaceConstraint",
		"edu.cmu.cs.stage3.alice.core.response.PointAtConstraint",
	],
],
["edu.cmu.cs.stage3.alice.core.visualization.ListOfModelsVisualization",
	["common animations",
		"edu.cmu.cs.stage3.alice.core.response.visualization.list.InsertItemAtBeginning",
		"edu.cmu.cs.stage3.alice.core.response.visualization.list.InsertItemAtEnd",
		"edu.cmu.cs.stage3.alice.core.response.visualization.list.InsertItemAtIndex",
		"edu.cmu.cs.stage3.alice.core.response.visualization.list.RemoveItemFromBeginning",
		"edu.cmu.cs.stage3.alice.core.response.visualization.list.RemoveItemFromEnd",
		"edu.cmu.cs.stage3.alice.core.response.visualization.list.RemoveItemFromIndex",
		"edu.cmu.cs.stage3.alice.core.response.visualization.list.Clear",

		"edu.cmu.cs.stage3.alice.core.response.MoveAnimation",
		"edu.cmu.cs.stage3.alice.core.response.TurnAnimation",
		"edu.cmu.cs.stage3.alice.core.response.RollAnimation",
		"edu.cmu.cs.stage3.alice.core.response.ResizeAnimation",
		"edu.cmu.cs.stage3.alice.core.response.TurnToFaceAnimation",
		"edu.cmu.cs.stage3.alice.core.response.PointAtAnimation",
		"edu.cmu.cs.stage3.alice.core.response.StandUpAnimation",
		"edu.cmu.cs.stage3.alice.core.response.PositionAnimation",
		"edu.cmu.cs.stage3.alice.core.response.QuaternionAnimation",
		"edu.cmu.cs.stage3.alice.core.response.PointOfViewAnimation",
		"edu.cmu.cs.stage3.alice.core.response.SoundResponse",
#			"edu.cmu.cs.stage3.alice.core.response.SendMessage",
		"edu.cmu.cs.stage3.alice.core.response.PoseAnimation",
		"edu.cmu.cs.stage3.alice.core.response.SayAnimation",
		"edu.cmu.cs.stage3.alice.core.response.MoveTowardAnimation",
		"edu.cmu.cs.stage3.alice.core.response.MoveAwayFromAnimation",

		["property animations",
			"edu.cmu.cs.stage3.alice.core.response.PropertyAnimation<color>",
			"edu.cmu.cs.stage3.alice.core.response.PropertyAnimation<opacity>",
			"edu.cmu.cs.stage3.alice.core.response.PropertyAnimation<vehicle>",
			"edu.cmu.cs.stage3.alice.core.response.PropertyAnimation<diffuseColorMap>",
			"edu.cmu.cs.stage3.alice.core.response.PropertyAnimation<fillingStyle>",
		],
	],
	["at speed animations",
		"edu.cmu.cs.stage3.alice.core.response.MoveAtSpeed",
		"edu.cmu.cs.stage3.alice.core.response.TurnAtSpeed",
		"edu.cmu.cs.stage3.alice.core.response.RollAtSpeed",
	],
	["constraints",
		"edu.cmu.cs.stage3.alice.core.response.TurnToFaceConstraint",
		"edu.cmu.cs.stage3.alice.core.response.PointAtConstraint",
	],
],
["edu.cmu.cs.stage3.alice.core.Camera",
	["common animations",
		"edu.cmu.cs.stage3.alice.core.response.MoveAnimation",
		"edu.cmu.cs.stage3.alice.core.response.TurnAnimation",
		"edu.cmu.cs.stage3.alice.core.response.RollAnimation",
		"edu.cmu.cs.stage3.alice.core.response.ResizeAnimation",
	],
	["communication animations",
		"edu.cmu.cs.stage3.alice.core.response.SayAnimation",
		"edu.cmu.cs.stage3.alice.core.response.ThinkAnimation",
		"edu.cmu.cs.stage3.alice.core.response.SoundResponse",
	],
	["advanced animations",
		"edu.cmu.cs.stage3.alice.core.response.GetAGoodLookAtAnimation",
		"edu.cmu.cs.stage3.alice.core.response.PositionAnimation",
		"edu.cmu.cs.stage3.alice.core.response.MoveTowardAnimation",
		"edu.cmu.cs.stage3.alice.core.response.MoveAwayFromAnimation",
		"edu.cmu.cs.stage3.alice.core.response.QuaternionAnimation",
		"edu.cmu.cs.stage3.alice.core.response.TurnToFaceAnimation",
		"edu.cmu.cs.stage3.alice.core.response.PointAtAnimation",
		"edu.cmu.cs.stage3.alice.core.response.PointOfViewAnimation",
		"edu.cmu.cs.stage3.alice.core.response.PoseAnimation",	
		"edu.cmu.cs.stage3.alice.core.response.StandUpAnimation",
	],
	["property animations",
		"edu.cmu.cs.stage3.alice.core.response.PropertyAnimation<color>",
		"edu.cmu.cs.stage3.alice.core.response.PropertyAnimation<opacity>",
		"edu.cmu.cs.stage3.alice.core.response.PropertyAnimation<vehicle>",
		"edu.cmu.cs.stage3.alice.core.response.PropertyAnimation<diffuseColorMap>",
		"edu.cmu.cs.stage3.alice.core.response.PropertyAnimation<fillingStyle>",
	],
	["at speed animations",
		"edu.cmu.cs.stage3.alice.core.response.MoveAtSpeed",
		"edu.cmu.cs.stage3.alice.core.response.TurnAtSpeed",
		"edu.cmu.cs.stage3.alice.core.response.RollAtSpeed",
	],
	["constraints",
		"edu.cmu.cs.stage3.alice.core.response.TurnToFaceConstraint",
		"edu.cmu.cs.stage3.alice.core.response.PointAtConstraint",
	],
],
["edu.cmu.cs.stage3.alice.core.Model",
	["common animations",
		"edu.cmu.cs.stage3.alice.core.response.MoveAnimation",
		"edu.cmu.cs.stage3.alice.core.response.TurnAnimation",
		"edu.cmu.cs.stage3.alice.core.response.RollAnimation",
		"edu.cmu.cs.stage3.alice.core.response.ResizeAnimation",
	],
	["communication animations",
		"edu.cmu.cs.stage3.alice.core.response.SayAnimation",
		"edu.cmu.cs.stage3.alice.core.response.ThinkAnimation",
		"edu.cmu.cs.stage3.alice.core.response.SoundResponse",
	],
	["advanced animations",
		"edu.cmu.cs.stage3.alice.core.response.PositionAnimation",
		"edu.cmu.cs.stage3.alice.core.response.MoveTowardAnimation",
		"edu.cmu.cs.stage3.alice.core.response.MoveAwayFromAnimation",
		"edu.cmu.cs.stage3.alice.core.response.QuaternionAnimation",
		"edu.cmu.cs.stage3.alice.core.response.TurnToFaceAnimation",
#		"edu.cmu.cs.stage3.alice.core.response.TurnAwayFromAnimation",
		"edu.cmu.cs.stage3.alice.core.response.PointAtAnimation",
		"edu.cmu.cs.stage3.alice.core.response.PointOfViewAnimation",
		"edu.cmu.cs.stage3.alice.core.response.PoseAnimation",	
		"edu.cmu.cs.stage3.alice.core.response.StandUpAnimation",
	],
	["property animations",
		"edu.cmu.cs.stage3.alice.core.response.PropertyAnimation<color>",
		"edu.cmu.cs.stage3.alice.core.response.PropertyAnimation<opacity>",
		"edu.cmu.cs.stage3.alice.core.response.PropertyAnimation<vehicle>",
		"edu.cmu.cs.stage3.alice.core.response.PropertyAnimation<diffuseColorMap>",
		"edu.cmu.cs.stage3.alice.core.response.PropertyAnimation<fillingStyle>",
	],
	["at speed animations",
		"edu.cmu.cs.stage3.alice.core.response.MoveAtSpeed",
		"edu.cmu.cs.stage3.alice.core.response.TurnAtSpeed",
		"edu.cmu.cs.stage3.alice.core.response.RollAtSpeed",
	],
	["constraints",
		"edu.cmu.cs.stage3.alice.core.response.TurnToFaceConstraint",
#		"edu.cmu.cs.stage3.alice.core.response.TurnAwayFromConstraint",
		"edu.cmu.cs.stage3.alice.core.response.PointAtConstraint",
	],
],
["edu.cmu.cs.stage3.alice.core.List",
	["common animations",
		"edu.cmu.cs.stage3.alice.core.response.list.InsertItemAtBeginning",
		"edu.cmu.cs.stage3.alice.core.response.list.InsertItemAtEnd",
		"edu.cmu.cs.stage3.alice.core.response.list.InsertItemAtIndex",
		"edu.cmu.cs.stage3.alice.core.response.list.RemoveItemFromBeginning",
		"edu.cmu.cs.stage3.alice.core.response.list.RemoveItemFromEnd",
		"edu.cmu.cs.stage3.alice.core.response.list.RemoveItemFromIndex",
		"edu.cmu.cs.stage3.alice.core.response.list.Clear",
	],
],
["edu.cmu.cs.stage3.alice.core.Array",
	["common animations",
		"edu.cmu.cs.stage3.alice.core.response.array.SetItemAtIndex",
	],
],
["java.lang.Number",
	["common animations",
		"edu.cmu.cs.stage3.alice.core.response.Increment",
		"edu.cmu.cs.stage3.alice.core.response.Decrement",
	],
],
["javax.vecmath.Vector3d",
	["common animations",
		"edu.cmu.cs.stage3.alice.core.response.vector3.SetX",
		"edu.cmu.cs.stage3.alice.core.response.vector3.SetY",
		"edu.cmu.cs.stage3.alice.core.response.vector3.SetZ",
	],
],
]


######################
# Question Config
######################

questionStructure = [
["edu.cmu.cs.stage3.alice.core.visualization.ModelVisualization",
	["item",
		"edu.cmu.cs.stage3.alice.core.question.visualization.model.Item",
	],
	["proximity",
		"edu.cmu.cs.stage3.alice.core.question.IsCloseTo",
		"edu.cmu.cs.stage3.alice.core.question.IsFarFrom",
		"edu.cmu.cs.stage3.alice.core.question.DistanceTo",
		"edu.cmu.cs.stage3.alice.core.question.DistanceToTheLeftOf",
		"edu.cmu.cs.stage3.alice.core.question.DistanceToTheRightOf",
		"edu.cmu.cs.stage3.alice.core.question.DistanceAbove",
		"edu.cmu.cs.stage3.alice.core.question.DistanceBelow",
		"edu.cmu.cs.stage3.alice.core.question.DistanceInFrontOf",
		"edu.cmu.cs.stage3.alice.core.question.DistanceBehind",
	],
	["size",
		"edu.cmu.cs.stage3.alice.core.question.Width",
		"edu.cmu.cs.stage3.alice.core.question.Height",
		"edu.cmu.cs.stage3.alice.core.question.Depth",
		"edu.cmu.cs.stage3.alice.core.question.IsSmallerThan",
		"edu.cmu.cs.stage3.alice.core.question.IsLargerThan",
		"edu.cmu.cs.stage3.alice.core.question.IsNarrowerThan",
		"edu.cmu.cs.stage3.alice.core.question.IsWiderThan",
		"edu.cmu.cs.stage3.alice.core.question.IsShorterThan",
		"edu.cmu.cs.stage3.alice.core.question.IsTallerThan",
	],
	["spatial relation",
		"edu.cmu.cs.stage3.alice.core.question.IsLeftOf",
		"edu.cmu.cs.stage3.alice.core.question.IsRightOf",
		"edu.cmu.cs.stage3.alice.core.question.IsAbove",
		"edu.cmu.cs.stage3.alice.core.question.IsBelow",
		"edu.cmu.cs.stage3.alice.core.question.IsInFrontOf",
		"edu.cmu.cs.stage3.alice.core.question.IsBehind",
	],
	["point of view",
		"edu.cmu.cs.stage3.alice.core.question.PointOfView",
		"edu.cmu.cs.stage3.alice.core.question.Position",
		"edu.cmu.cs.stage3.alice.core.question.Quaternion",
	],
	["other",
		"edu.cmu.cs.stage3.alice.core.question.Pose",
		"edu.cmu.cs.stage3.alice.core.question.PartKeyed",
		"edu.cmu.cs.stage3.alice.core.question.VariableNamed",
	],
],
["edu.cmu.cs.stage3.alice.core.visualization.ArrayOfModelsVisualization",
	["array",
		"edu.cmu.cs.stage3.alice.core.question.visualization.array.ItemAtIndex",
		"edu.cmu.cs.stage3.alice.core.question.visualization.array.Size",
	],
	["proximity",
		"edu.cmu.cs.stage3.alice.core.question.IsCloseTo",
		"edu.cmu.cs.stage3.alice.core.question.IsFarFrom",
		"edu.cmu.cs.stage3.alice.core.question.DistanceTo",
		"edu.cmu.cs.stage3.alice.core.question.DistanceToTheLeftOf",
		"edu.cmu.cs.stage3.alice.core.question.DistanceToTheRightOf",
		"edu.cmu.cs.stage3.alice.core.question.DistanceAbove",
		"edu.cmu.cs.stage3.alice.core.question.DistanceBelow",
		"edu.cmu.cs.stage3.alice.core.question.DistanceInFrontOf",
		"edu.cmu.cs.stage3.alice.core.question.DistanceBehind",
	],
	["size",
		"edu.cmu.cs.stage3.alice.core.question.Width",
		"edu.cmu.cs.stage3.alice.core.question.Height",
		"edu.cmu.cs.stage3.alice.core.question.Depth",
		"edu.cmu.cs.stage3.alice.core.question.IsSmallerThan",
		"edu.cmu.cs.stage3.alice.core.question.IsLargerThan",
		"edu.cmu.cs.stage3.alice.core.question.IsNarrowerThan",
		"edu.cmu.cs.stage3.alice.core.question.IsWiderThan",
		"edu.cmu.cs.stage3.alice.core.question.IsShorterThan",
		"edu.cmu.cs.stage3.alice.core.question.IsTallerThan",
	],
	["spatial relation",
		"edu.cmu.cs.stage3.alice.core.question.IsLeftOf",
		"edu.cmu.cs.stage3.alice.core.question.IsRightOf",
		"edu.cmu.cs.stage3.alice.core.question.IsAbove",
		"edu.cmu.cs.stage3.alice.core.question.IsBelow",
		"edu.cmu.cs.stage3.alice.core.question.IsInFrontOf",
		"edu.cmu.cs.stage3.alice.core.question.IsBehind",
	],
	["point of view",
		"edu.cmu.cs.stage3.alice.core.question.PointOfView",
		"edu.cmu.cs.stage3.alice.core.question.Position",
		"edu.cmu.cs.stage3.alice.core.question.Quaternion",
	],
	["other",
		"edu.cmu.cs.stage3.alice.core.question.Pose",
		"edu.cmu.cs.stage3.alice.core.question.PartKeyed",
		"edu.cmu.cs.stage3.alice.core.question.VariableNamed",
	],
],
["edu.cmu.cs.stage3.alice.core.visualization.ListOfModelsVisualization",
	["list",
		"edu.cmu.cs.stage3.alice.core.question.visualization.list.ItemAtBeginning",
		"edu.cmu.cs.stage3.alice.core.question.visualization.list.ItemAtEnd",
		"edu.cmu.cs.stage3.alice.core.question.visualization.list.ItemAtIndex",
		"edu.cmu.cs.stage3.alice.core.question.visualization.list.FirstIndexOfItem",
		"edu.cmu.cs.stage3.alice.core.question.visualization.list.LastIndexOfItem",
		"edu.cmu.cs.stage3.alice.core.question.visualization.list.Contains",
		"edu.cmu.cs.stage3.alice.core.question.visualization.list.IsEmpty",
		"edu.cmu.cs.stage3.alice.core.question.visualization.list.Size",
	],
	["proximity",
		"edu.cmu.cs.stage3.alice.core.question.IsCloseTo",
		"edu.cmu.cs.stage3.alice.core.question.IsFarFrom",
		"edu.cmu.cs.stage3.alice.core.question.DistanceTo",
		"edu.cmu.cs.stage3.alice.core.question.DistanceToTheLeftOf",
		"edu.cmu.cs.stage3.alice.core.question.DistanceToTheRightOf",
		"edu.cmu.cs.stage3.alice.core.question.DistanceAbove",
		"edu.cmu.cs.stage3.alice.core.question.DistanceBelow",
		"edu.cmu.cs.stage3.alice.core.question.DistanceInFrontOf",
		"edu.cmu.cs.stage3.alice.core.question.DistanceBehind",
	],
	["size",
		"edu.cmu.cs.stage3.alice.core.question.Width",
		"edu.cmu.cs.stage3.alice.core.question.Height",
		"edu.cmu.cs.stage3.alice.core.question.Depth",
		"edu.cmu.cs.stage3.alice.core.question.IsSmallerThan",
		"edu.cmu.cs.stage3.alice.core.question.IsLargerThan",
		"edu.cmu.cs.stage3.alice.core.question.IsNarrowerThan",
		"edu.cmu.cs.stage3.alice.core.question.IsWiderThan",
		"edu.cmu.cs.stage3.alice.core.question.IsShorterThan",
		"edu.cmu.cs.stage3.alice.core.question.IsTallerThan",
	],
	["spatial relation",
		"edu.cmu.cs.stage3.alice.core.question.IsLeftOf",
		"edu.cmu.cs.stage3.alice.core.question.IsRightOf",
		"edu.cmu.cs.stage3.alice.core.question.IsAbove",
		"edu.cmu.cs.stage3.alice.core.question.IsBelow",
		"edu.cmu.cs.stage3.alice.core.question.IsInFrontOf",
		"edu.cmu.cs.stage3.alice.core.question.IsBehind",
	],
	["point of view",
		"edu.cmu.cs.stage3.alice.core.question.PointOfView",
		"edu.cmu.cs.stage3.alice.core.question.Position",
		"edu.cmu.cs.stage3.alice.core.question.Quaternion",
	],
	["other",
		"edu.cmu.cs.stage3.alice.core.question.Pose",
		"edu.cmu.cs.stage3.alice.core.question.PartKeyed",
		"edu.cmu.cs.stage3.alice.core.question.VariableNamed",
	],
],
["edu.cmu.cs.stage3.alice.core.World",
	["boolean logic",
		"edu.cmu.cs.stage3.alice.core.question.Not",
		"edu.cmu.cs.stage3.alice.core.question.And",
		"edu.cmu.cs.stage3.alice.core.question.Or",
	],
	["math",
		"edu.cmu.cs.stage3.alice.core.question.NumberIsEqualTo",
		"edu.cmu.cs.stage3.alice.core.question.NumberIsNotEqualTo",
		"edu.cmu.cs.stage3.alice.core.question.NumberIsGreaterThan",
		"edu.cmu.cs.stage3.alice.core.question.NumberIsGreaterThanOrEqualTo",
		"edu.cmu.cs.stage3.alice.core.question.NumberIsLessThan",
		"edu.cmu.cs.stage3.alice.core.question.NumberIsLessThanOrEqualTo",
	],
	["random",
		"edu.cmu.cs.stage3.alice.core.question.RandomBoolean",
		"edu.cmu.cs.stage3.alice.core.question.RandomNumber",
	],
	["string",
		"edu.cmu.cs.stage3.alice.core.question.StringConcatQuestion",
		"edu.cmu.cs.stage3.alice.core.question.ToStringQuestion",
	],
	["ask user",
		"edu.cmu.cs.stage3.alice.core.question.ask.AskUserForNumber",
		"edu.cmu.cs.stage3.alice.core.question.ask.AskUserYesNo",
		"edu.cmu.cs.stage3.alice.core.question.ask.AskUserForString",
	],
	["mouse",
		"edu.cmu.cs.stage3.alice.core.question.mouse.DistanceFromLeftEdge",
		"edu.cmu.cs.stage3.alice.core.question.mouse.DistanceFromTopEdge",
	],
	["time",
		"edu.cmu.cs.stage3.alice.core.question.time.TimeElapsedSinceWorldStart",
		"edu.cmu.cs.stage3.alice.core.question.time.Year",
		"edu.cmu.cs.stage3.alice.core.question.time.MonthOfYear",
		"edu.cmu.cs.stage3.alice.core.question.time.DayOfYear",
		"edu.cmu.cs.stage3.alice.core.question.time.DayOfMonth",
		"edu.cmu.cs.stage3.alice.core.question.time.DayOfWeek",
		"edu.cmu.cs.stage3.alice.core.question.time.DayOfWeekInMonth",
		"edu.cmu.cs.stage3.alice.core.question.time.IsAM",
		"edu.cmu.cs.stage3.alice.core.question.time.IsPM",
		"edu.cmu.cs.stage3.alice.core.question.time.HourOfAMOrPM",
		"edu.cmu.cs.stage3.alice.core.question.time.HourOfDay",
		"edu.cmu.cs.stage3.alice.core.question.time.MinuteOfHour",
		"edu.cmu.cs.stage3.alice.core.question.time.SecondOfMinute",
	],
	["advanced math",
		"edu.cmu.cs.stage3.alice.core.question.math.Min",
		"edu.cmu.cs.stage3.alice.core.question.math.Max",
		"edu.cmu.cs.stage3.alice.core.question.math.Abs",
		"edu.cmu.cs.stage3.alice.core.question.math.Sqrt",
		"edu.cmu.cs.stage3.alice.core.question.math.Floor",
		"edu.cmu.cs.stage3.alice.core.question.math.Ceil",
		"edu.cmu.cs.stage3.alice.core.question.math.Sin",
		"edu.cmu.cs.stage3.alice.core.question.math.Cos",
		"edu.cmu.cs.stage3.alice.core.question.math.Tan",
		"edu.cmu.cs.stage3.alice.core.question.math.ACos",
		"edu.cmu.cs.stage3.alice.core.question.math.ASin",
		"edu.cmu.cs.stage3.alice.core.question.math.ATan",
		"edu.cmu.cs.stage3.alice.core.question.math.ATan2",
		"edu.cmu.cs.stage3.alice.core.question.math.Pow",
		"edu.cmu.cs.stage3.alice.core.question.math.Log",
		"edu.cmu.cs.stage3.alice.core.question.math.Exp",
		"edu.cmu.cs.stage3.alice.core.question.math.IEEERemainder",
		"edu.cmu.cs.stage3.alice.core.question.math.Int",
		"edu.cmu.cs.stage3.alice.core.question.math.Round",
		"edu.cmu.cs.stage3.alice.core.question.math.ToDegrees",
		"edu.cmu.cs.stage3.alice.core.question.math.ToRadians",
		"edu.cmu.cs.stage3.alice.core.question.math.SuperSqrt",
	],
	["other",
		"edu.cmu.cs.stage3.alice.core.question.RightUpForward"
	],
],
["edu.cmu.cs.stage3.alice.core.Transformable",
	["proximity",
		"edu.cmu.cs.stage3.alice.core.question.IsCloseTo",
		"edu.cmu.cs.stage3.alice.core.question.IsFarFrom",
		"edu.cmu.cs.stage3.alice.core.question.DistanceTo",
		"edu.cmu.cs.stage3.alice.core.question.DistanceToTheLeftOf",
		"edu.cmu.cs.stage3.alice.core.question.DistanceToTheRightOf",
		"edu.cmu.cs.stage3.alice.core.question.DistanceAbove",
		"edu.cmu.cs.stage3.alice.core.question.DistanceBelow",
		"edu.cmu.cs.stage3.alice.core.question.DistanceInFrontOf",
		"edu.cmu.cs.stage3.alice.core.question.DistanceBehind",
	],
	["size",
		"edu.cmu.cs.stage3.alice.core.question.Width",
		"edu.cmu.cs.stage3.alice.core.question.Height",
		"edu.cmu.cs.stage3.alice.core.question.Depth",
		"edu.cmu.cs.stage3.alice.core.question.IsSmallerThan",
		"edu.cmu.cs.stage3.alice.core.question.IsLargerThan",
		"edu.cmu.cs.stage3.alice.core.question.IsNarrowerThan",
		"edu.cmu.cs.stage3.alice.core.question.IsWiderThan",
		"edu.cmu.cs.stage3.alice.core.question.IsShorterThan",
		"edu.cmu.cs.stage3.alice.core.question.IsTallerThan",
	],
	["spatial relation",
		"edu.cmu.cs.stage3.alice.core.question.IsLeftOf",
		"edu.cmu.cs.stage3.alice.core.question.IsRightOf",
		"edu.cmu.cs.stage3.alice.core.question.IsAbove",
		"edu.cmu.cs.stage3.alice.core.question.IsBelow",
		"edu.cmu.cs.stage3.alice.core.question.IsInFrontOf",
		"edu.cmu.cs.stage3.alice.core.question.IsBehind",
	],
	["point of view",
		"edu.cmu.cs.stage3.alice.core.question.PointOfView",
		"edu.cmu.cs.stage3.alice.core.question.Position",
		"edu.cmu.cs.stage3.alice.core.question.Quaternion",
	],
	["other",
		"edu.cmu.cs.stage3.alice.core.question.Pose",
		"edu.cmu.cs.stage3.alice.core.question.PartKeyed",
		"edu.cmu.cs.stage3.alice.core.question.VariableNamed",
	],
],
]


######################
# Behavior Config
######################

behaviorList = [
	edu.cmu.cs.stage3.alice.core.behavior.WorldStartBehavior,
	edu.cmu.cs.stage3.alice.core.behavior.KeyClickBehavior,
	edu.cmu.cs.stage3.alice.core.behavior.MouseButtonClickBehavior,
	edu.cmu.cs.stage3.alice.core.behavior.ConditionalBehavior,
	edu.cmu.cs.stage3.alice.core.behavior.VariableChangeBehavior,
	edu.cmu.cs.stage3.alice.core.behavior.DefaultMouseInteractionBehavior,
	edu.cmu.cs.stage3.alice.core.behavior.KeyboardNavigationBehavior,
	edu.cmu.cs.stage3.alice.core.behavior.MouseNavigationBehavior,
	edu.cmu.cs.stage3.alice.core.behavior.MouseLookingBehavior,
#	edu.cmu.cs.stage3.alice.core.behavior.MessageReceivedBehavior,
#	edu.cmu.cs.stage3.alice.core.behavior.SoundMarkerPassedBehavior,
#	edu.cmu.cs.stage3.alice.core.behavior.SoundLevelBehavior,
]

behaviorParameterProperties = [
["edu.cmu.cs.stage3.alice.core.behavior.KeyClickBehavior",
	"keyCode",
],
["edu.cmu.cs.stage3.alice.core.behavior.KeyIsPressedBehavior",
	"keyCode",
],
["edu.cmu.cs.stage3.alice.core.behavior.MouseButtonClickBehavior",
	"onWhat",
],
["edu.cmu.cs.stage3.alice.core.behavior.MouseButtonIsPressedBehavior",
	"onWhat",
],
["edu.cmu.cs.stage3.alice.core.behavior.VariableChangeBehavior",
	"variable",
],
["edu.cmu.cs.stage3.alice.core.behavior.MessageReceivedBehavior",
	"fromWho",
	"toWhom",
],
["edu.cmu.cs.stage3.alice.core.behavior.DefaultMouseInteractionBehavior",
	"objects",
],
["edu.cmu.cs.stage3.bb2.navigation.KeyboardNavigationBehavior",
	"subject",
],
["edu.cmu.cs.stage3.bb2.navigation.MouseNavigationBehavior",
	"transformable",
	"mode",
],
["edu.cmu.cs.stage3.alice.core.behavior.WorldIsRunningBehavior",
],
["edu.cmu.cs.stage3.alice.core.behavior.ConditionalBehavior",
	"condition",
],
["edu.cmu.cs.stage3.alice.core.behavior.SoundMarkerPassedBehavior",
	"marker",
],
["edu.cmu.cs.stage3.alice.core.behavior.SoundLevelBehavior",
	"level",
],
]


####################
# Variable Config
####################

defaultVariableTypes = [
	("String", java.lang.String),
	("Color", edu.cmu.cs.stage3.alice.scenegraph.Color),
	("TextureMap", edu.cmu.cs.stage3.alice.core.TextureMap),
	("Sound", edu.cmu.cs.stage3.alice.core.Sound),
	("Pose", edu.cmu.cs.stage3.alice.core.Pose),
	("Position", edu.cmu.cs.stage3.math.Vector3),
	("Orientation", edu.cmu.cs.stage3.math.Quaternion),
	("PointOfView", javax.vecmath.Matrix4d),
	("ReferenceFrame", edu.cmu.cs.stage3.alice.core.ReferenceFrame),
	("Transformable", edu.cmu.cs.stage3.alice.core.Transformable),
	("Light", edu.cmu.cs.stage3.alice.core.Light),
	("Direction", edu.cmu.cs.stage3.alice.core.Direction),
	("3D Text", edu.cmu.cs.stage3.alice.core.Text3D),
]


######################
# Importer Config
######################

importerList = [
	edu.cmu.cs.stage3.alice.authoringtool.importers.ImageImporter,
	edu.cmu.cs.stage3.alice.authoringtool.importers.MediaImporter,
	edu.cmu.cs.stage3.alice.authoringtool.importers.ASEImporter,
	edu.cmu.cs.stage3.alice.authoringtool.importers.mocap.ASFImporter,
	edu.cmu.cs.stage3.alice.authoringtool.importers.mocap.AMCImporter,
	edu.cmu.cs.stage3.alice.authoringtool.importers.ScenegraphImporter,
]


######################
# Editor Config
######################

editorList = [
#	edu.cmu.cs.stage3.alice.authoringtool.editors.sceneeditor.SceneEditor,
	edu.cmu.cs.stage3.alice.authoringtool.editors.texturemapviewer.TextureMapViewer,
	edu.cmu.cs.stage3.alice.authoringtool.editors.responseeditor.ResponseEditor,
	edu.cmu.cs.stage3.alice.authoringtool.editors.scripteditor.ScriptEditor,
#	edu.cmu.cs.stage3.alice.authoringtool.editors.modelfixer.ModelFixer,
#	edu.cmu.cs.stage3.alice.authoringtool.editors.soundeditor.SoundEditor,
	edu.cmu.cs.stage3.alice.authoringtool.editors.keymappingeditor.KeyMappingEditor,
	edu.cmu.cs.stage3.alice.authoringtool.editors.questioneditor.QuestionEditor,
]


#########################
# Gallery
#########################

mainWebGalleryURL = "http://www.alice.org/gallery/"
mainDiskGallery = "gallery"
mainCDGalleryName = "CDGallery"

mainUpdateURL = "http://www.alice.org/downloads/2.4/"


#########################
# Misc
#########################

defaultAspectRatios = [
	"4/3",
	"1.85",
	"2.35",
]


miscMap = {
	"tileEdgeTreatment" : "rounded",  # options: "rounded", "square"
}

